<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Rops;
use Inside\Content\Models\Contents\Sops;
use Inside\Host\Bridge\BridgeContent;

class RemoveOldSopRop extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        Rops::whereDoesntHave('countries')->where('status', 1)->each(function ($rop) use ($bridge) {
            $bridge->contentUpdate('rops', ['uuid' => $rop->uuid, 'status' => 0]);
        });

        Sops::whereDoesntHave('countries')->where('status', 1)->each(function ($sop) use ($bridge) {
            $bridge->contentUpdate('sops', ['uuid' => $sop->uuid, 'status' => 0]);
        });
    }
}
