<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Host\Migrations\CreateContentTypes;

class FixLabelFieldInCtaParagraph extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'Call to action section type');

        $this->migrateContent('call_to_action', false, 'sections');

        $this->finishUp();

        DynamicClass::enableRebuildAutoLoad();

        $this->call('models:rebuild');
    }
}
