<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIconPickersOnFolders extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'folders',
            'icon',
            [
                'name' => 'icon',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 109,
                'title' => [
                    'fr' => 'Icone',
                    'en' => 'Icon',
                ],
                'description' => [
                    'fr' => 'Définissez une icône pour votre dossier qui sera visible en page d\'accueil',
                    'en' => 'Define an icon for your folder that will be visible on the home page',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                    'settings' => [],
                    'weight' => 109,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );
    }
}
