<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddSopsFieldOnSopsAndDocuments extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();

        $this->bootUp(__FILE__, 'add_news_user_fields');

        $contentTypes = ['sops', 'documents'];

        foreach ($contentTypes as $contentType) {
            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'sops', [
                'name' => 'sops',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'en' => 'Sops',
                    'fr' => 'Sops',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['sops'],
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ]);
        }

        $this->finishUp();

        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }
}
