<?php

use Illuminate\Database\Migrations\Migration;

class FixSelectableAll extends Migration
{
    public function up(): void
    {
        $contentTypes = ['sops', 'rops', 'documents', 'declined_documents'];
        $fields = ['brands', 'countries', 'management_modes', 'profiles'];

        $bridge = new Inside\Host\Bridge\BridgeContentType();

        foreach ($contentTypes as $contentType) {
            foreach ($fields as $field) {
                $bridge->updateFieldOptions($contentType, $field, ['selectable_all' => true]);
            }
        }
    }

    public function down(): void
    {
    }
}
