<?php

use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Migrations\ReportMigration;
use Inside\Notify\Models\NotificationType;

class AddReportNotifications extends ReportMigration
{
    use CreateContentTypes;

    public function up(): void
    {
        $output = $this->getConsole();

        $output->write('<info>Réinscription des administrateurs aux notifications de report.</info>');

        NotificationType::query()->where('action', 'report')->delete();

        $types = ['sops', 'rops', 'documents', 'declined_documents'];

        foreach ($types as $type) {
            $this->registerReport(
                ['super_administrator'],
                $type,
                true,
                true,
                'CUSTOM:bclh_ged'
            );
        }

        $output->writeln(' <fg=green>✔</fg=green>');
    }

    public function down(): void
    {
    }
}
