<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddUpdatedByField extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $contentTypes = ['sops', 'rops', 'documents', 'declined_documents'];

        foreach ($contentTypes as $contentType) {
            $bridgeContentType->contentTypeCreateOrUpdateField($contentType, 'updated_by', [
                'type'                => BridgeContentType::REFERENCE_FIELD,
                'name'                => 'updated_by',
                'searchable'          => false,
                'translatable'        => false,
                'search_result_field' => false,
                'required'            => false,
                'weight'              => 0,
                'default' => [],
                'title'               => [
                    'fr' => 'Mis à jour par',
                    'en' => 'Updated by',
                ],
                'description'         => [],
                'settings' => [
                    'cardinality' => -1,
                    'target_type' => 'users',
                ],
                'widget'              => [
                    'hidden' => true,
                ],
            ]);
        }
    }

    public function down(): void
    {
    }
}
