<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class BrandFormsMigration extends Migration
{
    use CreateContentTypes;

    /**
     * @var array
     */
    protected $layouts = [
        'inside_content_brand_forms' => [
            'paths' => [
                'en' => 'inside_content_brand_forms',
                'fr' => 'inside_content_brand_forms',
            ],
            'config' => [
                'blocks' => '{"block-brand-forms-customs-layouts-ihcjorkve-0":{"parentID":"layouts-ihcjorkve","module":{"module":"InsideCustoms","display":"brand-forms"},"blockID":"block-brand-forms-customs-layouts-ihcjorkve-0","blockName":"brand-forms-customs","blockData":{},"blockOptions":{"content":{"contentTypes":["brand_forms"],"blockFilters":[{"key":"slug","value":"campanile-signature","index":0,"type":"filter","fieldType":"text","target":null,"operation":"eq"}],"blockFiltersDefault":{"sort":null,"limit":null,"offset":null,"order":"asc","paginate":0,"tree_sort":null,"tree_order":null},"blockFields":[{"fieldType":"checkbox","key":"status","value":null},{"fieldType":"text","key":"form_id","value":null},{"fieldType":"wysiwyg","key":"introduction","value":null},{"fieldType":"onoff","key":"admin","value":null},{"fieldType":"text","key":"title","value":null},{"fieldType":"string","key":"slug","value":null},{"fieldType":"string","key":"uuid","value":null},{"key":"content_type","isReversed":false,"index":7,"type":"field","value":null,"fieldType":"text","target":null,"filters":{"limit":null,"offset":null,"order":"asc","reverse":false,"sort":null}}],"formattedContents":"brand_forms","formattedFields":["status","form_id","introduction","admin","title","slug","uuid","content_type"],"formattedFilters":{"slug:eq":"campanile-signature"},"normalizer":null},"general":{"blockImageDisplay":"content","blockTitle":null,"blockSubtitle":"","blockAlignment":"left","blockImage":null,"blockImageHeight":25,"blockClass":"","hasBlockImage":false,"hasNoData":null,"relativeBlock":"parent","parentBlock":null,"childFilters":[],"hasGeneralLink":false,"urlGeneralLink":null,"urlGeneralLinkHide":null,"urlGeneralLabel":null,"printable":true,"useDefaultHeaderLayout":true,"useDefaultLinkLayout":true,"hideBlock":null},"display":{},"filters":{},"list":{},"custom":{}},"blockPos":0,"isMainBlock":true}}',
                'layout' => '{"rows-0":{"id":"rows-0","forms":{},"layouts":{"layouts-ihcjorkve":{"rows":{"rows-ihcjorkve-0":{"id":"rows-ihcjorkve-0","layouts":{},"layoutCounter":0}},"id":"layouts-ihcjorkve","columns":1,"blocks":["block-brand-forms-customs-layouts-ihcjorkve-0"],"options":{"colOptions":{"0":{"width":{"value":null,"unit":null},"margins":{"top":0,"right":0,"bottom":0,"left":0}}},"width":{},"maxWidth":{}}}},"layoutCounter":1}}',
                'option' => '{"allowedContents":[]}',
            ],
        ],
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('brand_forms', false);

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
