<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersAttributesCombinaisonsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_users_attributes_combinaisons', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('brand_uuid', 36)->collate('utf8'); // La marque
            $table->char('country_uuid', 36)->collate('utf8'); // Le pays
            $table->char('profile_uuid', 36)->collate('utf8'); // Le profil
            $table->char('status_uuid', 36)->collate('utf8'); // Le status

            $table->unique(['brand_uuid', 'country_uuid', 'profile_uuid', 'status_uuid'], 'unique_tuple');
        });
        Schema::table('inside_users_attributes_combinaisons', function (Blueprint $table) {
            $table->foreign('brand_uuid', 'iuac_brand_uuid_foreign')
                ->references('uuid')->on('inside_content_brands')
                ->onDelete('cascade');
            $table->foreign('country_uuid', 'iuac_country_uuid_foreign')
                ->references('uuid')->on('inside_content_countries')
                ->onDelete('cascade');
            $table->foreign('profile_uuid', 'iuac_profile_uuid_foreign')
                ->references('uuid')->on('inside_content_profiles')
                ->onDelete('cascade');
            $table->foreign('status_uuid', 'iuac_status_uuid_foreign')
                ->references('uuid')->on('inside_content_management_modes')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('inside_users_attributes_combinaisons', function (Blueprint $table) {
            $table->dropForeign('iuac_brand_uuid_foreign');
            $table->dropForeign('iuac_country_uuid_foreign');
            $table->dropForeign('iuac_profile_uuid_foreign');
            $table->dropForeign('iuac_status_uuid_foreign');
        });
        Schema::dropIfExists('inside_users_attributes_combinaisons');
    }
}
