<?php

use Illuminate\Support\Facades\DB;

return [
    'content_is_declined' => function ($content) {
        switch ($content->content_type) {
            case 'rops':
                $contentType = 'rops';
                $parentContentType = 'sops';
                break;
            case 'declined_documents':
                $contentType = 'declined_documents';
                $parentContentType = 'documents';
                break;
            default:
                return false;
        }

        $isDeclined = DB::table('inside_pivots')
            ->where('parent_uuid', $content->uuid)
            ->where('parent_type', type_to_class($contentType))
            ->where('related_type', type_to_class($parentContentType))
            ->exists();

        /**
         * We check if the ROP is related to a SOP. But an ROP can be created from form or declension.
         * If it's from declension, the status is forced to false, the asker of the declension when to edit this ROP to add new content before launch it in workflow.
         * If it's from form, the status is set by the auther. If it's set to true, it's not a declension and we need to dispatch it in workflow for review.
         */
        if ($isDeclined && $content->status === false) {
            return true;
        }

        return false;
    },
];
