<?php

use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\EntityReferenceField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\EntityReferenceRevisionsField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\ImageField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringLongField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TextLongField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TimestampField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\BaseStorage;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Paragraphs\ParagraphsTypeBundle;

return [
    /*
    |--------------------------------------------------------------------------
    | Paragraphs custom
    |--------------------------------------------------------------------------
    |
    | You can override in the back repository this configuration to add
    | your own cutsomized paragraphs.
    |
    */
    'custom' => [
        'step' => [
            'label' => 'field.step.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                ],
                'field_body' => [
                    'class' => TextLongField::class,
                    'label' => 'field.body.label',
                ],
                'field_image' => [
                    'class' => ImageField::class,
                    'label' => 'field.image.label',
                ],
            ],
        ],
        'steps' => [
            'label' => 'field.steps.label',
            'fields' => [
                'field_content' => [
                    'class' => EntityReferenceRevisionsField::class,
                    'label' => 'field.content.label',
                    'target_type' => ParagraphsTypeBundle::Type,
                    'target_bundles' => [
                        'step' =>  'step',
                    ],
                    'cardinality' => BaseStorage::MultipleCardinality,
                ],
            ],
        ],
        'tabs' => [
            'label' => 'field.tabs.label',
            'fields' => [
                'field_pages' => [
                    'class' => EntityReferenceField::class,
                    'label' => 'field.pages.label',
                    'target_type' => 'node',
                    'target_bundles' => [
                        'pages' =>  'pages',
                    ],
                    'cardinality' => BaseStorage::MultipleCardinality,
                ],
            ],
        ],
        'invite' => [
            'label' => 'field.invite.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                ],
                'field_description' => [
                    'class' => StringLongField::class,
                    'label' => 'field.description.label',
                ],
                'field_date' => [
                    'class' => TimestampField::class,
                    'label' => 'field.start_date.label',
                    'required' => true,
                ],
                'field_end_date' => [
                    'class' => TimestampField::class,
                    'label' => 'field.end_date.label',
                    'required' => true,
                ],
                'field_place' => [
                    'class' => StringField::class,
                    'label' => 'field.place.label',
                ],
                'field_invite_link' => [
                    'class' => StringField::class,
                    'label' => 'field.link.label',
                ],
            ],
        ],
    ],
];
