<?php

use Illuminate\Support\Arr;
use Inside\Content\Facades\ContentHelper;

if (! function_exists('clean_content_types')) {
    function clean_content_types(array $content): array
    {
        return Arr::except(
            $content,
            config('external_api.inside_external_api_fields_content_remove')
        );
    }
}

return [
    'inside_external_api_enabled' => env('INSIDE_EXTERNAL_API_ENABLED', true),
    'inside_external_api_bypass_auth_external' => env('INSIDE_EXTERNAL_API_AUTH_BYPASS', true),
    'inside_external_api_pagination_limit' => 50,
    'inside_external_api_fields' => [
        'brands' => [
            'uuid',
            'langcode',
            'title',
            'code',
            'updated_at',
        ],
        'profiles' => [
            'uuid',
            'langcode',
            'title',
            'code',
            'updated_at',
        ],
        'management_modes' => [
            'uuid',
            'langcode',
            'title',
            'code',
            'updated_at',
        ],
        'sops' => [
            'uuid',
            'langcode',
            'title',
            'slug',
            'goal',
            'standard',
            'file',
            'content',
            'users',
            'brands' => ['title', 'code'],
            'countries' => ['title', 'code'],
            'management_modes' => ['title', 'code'],
            'profiles' => ['title', 'code'],
            'folders' => ['title'],
            'last_update',
            'updated_at',
        ],
        'rops' => [
            'uuid',
            'langcode',
            'title',
            'slug',
            'goal',
            'standard',
            'file',
            'content',
            'users',
            'brands' => ['title', 'code'],
            'countries' => ['title', 'code'],
            'management_modes' => ['title', 'code'],
            'profiles' => ['title', 'code'],
            'folders' => ['title'],
            'sops',
            'last_update',
            'updated_at',
        ],
        'documents' => [
            'uuid',
            'title',
            'langcode',
            'introduction',
            'file',
            'slug',
            'content',
            'brands' => ['title'],
            'countries' => ['title'],
            'management_modes' => ['title'],
            'profiles' => ['title'],
            'folders' => ['title'],
            'last_update',
            'updated_at',
        ],
    ],
    'inside_external_api_fields_content_remove' => [
        'uuid',
        'created_at',
        'updated_at',
        'reactions',
        'published_at',
        'statistics',
        'unique_views',
        'total_views',
        'archived',
        'description',
    ],
    'inside_external_api_filters' => function ($query, $request) {
        $query->where('status', 1);
        if ($request->has('langcode')) {
            $query->where('langcode', $request->get('langcode'));
        }
        if ($request->has('updated_at')) {
            $timestamp = $request->get('updated_at');
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', $timestamp));
        }

        return $query;
    },
    'inside_external_api_transform' => function ($result) {
        $result->transform(function ($data) {
            if (isset($data['content'])) {
                $data['content'] = collect($data['content'])->transform(
                    fn ($content) => isset($content['content']) ?
                      collect($content['content'])
                        ->transform(fn ($content) => clean_content_types($content))
                        ->filter()
                        ->toArray()
                      : clean_content_types($content)
                )->filter()->toArray();
            }

            if (isset($data['sops']) && isset($data['sops']['data'][0]['content'])) {
                $data['sops']['data'][0]['content'] = collect($data['sops']['data'][0]['content'])->transform(
                    fn ($content) => isset($content['content']) ?
                      collect($content['content'])
                        ->transform(fn ($content) => clean_content_types($content))
                        ->filter()
                        ->toArray()
                      : clean_content_types($content)
                )->filter()->toArray();
            }

            if (! isset($data['content'])) {
                $data['content'] = [];
            }

            return $data;
        })->toArray();

        return $result;
    },
];
