<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\BCLH\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('ebook', ['uses' => 'ExportController@ebook']);
        $router->get('basket', ['uses' => 'ExportController@basket']);
        $router->get('bclh/bulk-csv/export', ['uses' => 'BulkCSVController@export']);
        $router->post('bclh/bulk-csv/import', ['uses' => 'BulkCSVController@import']);
        $router->post('bclh/duplicate', ['uses' => 'DuplicateController@duplicate']);
        $router->post('bclh/image/export', ['uses' => 'ExportController@image']);
        $router->post('bclh/bulkupdate', ['uses' => 'BulkUpdateController@handle']);
        $router->get('bclh/sop/export', ['uses' => 'SopExportController@invoke']);
        $router->post('bclh/sop/import', ['uses' => 'SopImportController@invoke']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\BCLH\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:postman_api'],
    ],
    function ($router) {
        $router->get('external/resource/{path:.*}', ['uses' => 'ExternalApiController@getResource']);
    }
);
