<?php

declare(strict_types=1);

namespace Inside\BCLH\Services;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Queue;
use Inside\Authentication\Models\User;
use Inside\BCLH\Jobs\ImportSopsFromExcel;

final class ExcelImporterService
{
    private string $file;

    public function setFile(string $file): self
    {
        $this->file = $file;

        return $this;
    }

    public function execute(): void
    {
        /** @var User $user */
        $user = Auth::user();
        Queue::push(new ImportSopsFromExcel($user->uuid, $this->file));
    }
}
