<?php

declare(strict_types=1);

namespace Inside\BCLH\Services;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Queue;
use Inside\Authentication\Models\User;
use Inside\BCLH\Jobs\ExportSopsInExcel;
use Inside\BCLH\Repository\ExportableContentRepository;

final class ExcelExporterService
{
    private array $filters = [];

    public function setFilters(array $filters): self
    {
        $this->filters = $filters;

        return $this;
    }

    public function execute(): void
    {
        /** @var User $user */
        $user = Auth::user();

        $request = request();
        $contentRepository = new ExportableContentRepository();
        $formattedContents = $contentRepository->getExportableSopsAndRops($this->filters);
        Queue::push(new ExportSopsInExcel($user->uuid, $formattedContents));
    }
}
