<?php

namespace Inside\BCLH\Providers;

use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\View;
use Inside\BCLH\Console\FixRopsFolders;
use Inside\BCLH\Console\GenerateAlbumsCommand;
use Inside\BCLH\Console\GeneratePdfsCommand;
use Inside\BCLH\Events\BasketGeneratedEvent;
use Inside\BCLH\Events\BulkCSVExportFailedEvent;
use Inside\BCLH\Events\BulkCSVGeneratedEvent;
use Inside\BCLH\Events\BulkCSVImportedEvent;
use Inside\BCLH\Events\BulkCSVImportFailedEvent;
use Inside\BCLH\Events\EbookGeneratedEvent;
use Inside\BCLH\Http\Middlewares\BCLHMiddleware;
use Inside\BCLH\Listeners\BasketGeneratedListener;
use Inside\BCLH\Listeners\BulkCSVExportFailedListener;
use Inside\BCLH\Listeners\BulkCSVGeneratedListener;
use Inside\BCLH\Listeners\BulkCSVImportedListener;
use Inside\BCLH\Listeners\BulkCSVImportFailedListener;
use Inside\BCLH\Listeners\ContentPublishedListener;
use Inside\BCLH\Listeners\EbookGeneratedListener;
use Inside\BCLH\Listeners\GenerateContentPdf;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Events\ContentSavedWithImages;
use Inside\Permission\Services\PermissionService;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\Workflow\Events\ProposalReviewedEvent;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use Webklex\PDFMerger\PDFMerger;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        BasketGeneratedEvent::class => [
            BasketGeneratedListener::class,
        ],
        EbookGeneratedEvent::class => [
            EbookGeneratedListener::class,
        ],
        ContentFullyInsertedEvent::class => [
            GenerateContentPdf::class,
        ],
        ContentFullyUpdatedEvent::class => [
            GenerateContentPdf::class,
        ],
        ContentSavedWithImages::class => [
            GenerateContentPdf::class,
        ],
        ProposalReviewedEvent::class => [
            ContentPublishedListener::class,
        ],
        BulkCSVGeneratedEvent::class => [
            BulkCSVGeneratedListener::class,
        ],
        BulkCSVImportedEvent::class => [
            BulkCSVImportedListener::class,
        ],
        BulkCSVImportFailedEvent::class => [
            BulkCSVImportFailedListener::class,
        ],
        BulkCSVExportFailedEvent::class => [
            BulkCSVExportFailedListener::class,
        ],
    ];

    protected array $commands = [
        GeneratePdfsCommand::class,
        GenerateAlbumsCommand::class,
        FixRopsFolders::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/archive.php', 'archive');
            $this->mergeConfigTo(__DIR__.'/../../config/louvrehotels.php', 'louvrehotels');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/workers.php', 'workers');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/workflow.php', 'workflow');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/content-trees.php', 'content-trees');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/generator/paragraphs.php', 'generator.paragraphs');
            $this->mergeConfigTo(__DIR__.'/../../config/newsletters.php', 'newsletters');
            $this->mergeConfigTo(__DIR__.'/../../config/external_api.php', 'external_api');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/horizon.php', 'horizon');
            $this->mergeConfigTo(__DIR__.'/../../config/audit.php', 'audit');

            if (! PermissionService::isSystemV2Initialized()) {
                $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            }
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->register(\Barryvdh\DomPDF\ServiceProvider::class);

        $this->app->alias('PDF', Pdf::class);
        $this->app->alias('PDFMerger', \Webklex\PDFMerger\Facades\PDFMergerFacade::class);
        $this->app->singleton('PDFMerger', function ($app) {
            $PDFMerger = new PDFMerger($app['files']);

            return $PDFMerger;
        });

        $this->app->middleware([
            BCLHMiddleware::class,
        ]);

        View::addNamespace(
            'iln',
            realpath(cms_base_path('vendor/maecia/bclh-back/resources/views/iln')) ?: ''
        );
    }
}
