<?php

namespace Inside\BCLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Queue;
use Inside\Authentication\Models\User;
use Inside\BCLH\Events\BasketGeneratedEvent;
use Inside\BCLH\Jobs\GenerateAlbumZip;
use Inside\BCLH\Jobs\GeneratePdf;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\Workflow\Events\ProposalReviewedEvent;

/**
 * Inside package content service.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentPublishedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ProposalReviewedEvent $event): void
    {
        $proposal = $event->proposal;
        $model = $event->proposable;

        if (! in_array($model->content_type, ['declined_documents'])) {
            return;
        }

        if ($proposal->status !== 1) {
            return;
        }

        $action = 'declinedDocumentCreated';

        if (isset($model->documents)) {
            $subscriber = User::query()->find($model->documents->first()->author);
        } else {
            $subscriber = null;
        }

        if (! $subscriber instanceof User) {
            return;
        }

        /** @var \Inside\Notify\Models\NotificationType[] $types */
        $types = NotificationType::where('action', $action)->get();

        foreach ($types as $type) {
            $this->when = $this->getInterval($type);
            $this->route = $subscriber;
            $this->notify($type, $subscriber, $model);
        }
    }
}
