<?php

namespace Inside\BCLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\BCLH\Events\BulkCSVImportFailedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class BulkCSVImportFailedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(BulkCSVImportFailedEvent $event): void
    {
        $user = User::query()->find($event->uuid);

        if (! $user instanceof User) {
            return;
        }

        /** @var \Inside\Notify\Models\NotificationType[] $types */
        $types = NotificationType::where('action', 'bulkCSV-import-failed')->get();

        foreach ($types as $type) {
            $this->when = $this->getInterval($type);
            $this->route = $user;
            $this->notify($type, $user);
        }
    }
}
