<?php

namespace Inside\BCLH\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DispatchEvent implements ShouldQueue
{
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * @var string
     */
    private $eventClass;

    /**
     * @var string
     */
    private $userId;

    /**
     * @var mixed
     */
    private $payload;

    /**
     * @param string $eventClass
     * @param string $userId
     * @param mixed $payload
     */
    public function __construct(string $eventClass, string $userId, $payload)
    {
        $this->eventClass = $eventClass;
        $this->payload = $payload;
        $this->userId = $userId;
    }

    public function handle(): void
    {
        event(new $this->eventClass($this->userId, $this->payload));
    }
}
