<?php

namespace Inside\BCLH\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Queue;
use Inside\BCLH\Jobs\BulkUpdate;

/**
 * Bulk update controller
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class BulkUpdateController
{
    public function handle(Request $request): JsonResponse
    {
        /** @var array $contents */
        $contents = $request->get('contents');
        $users = $request->get('users');
        $brands = $request->get('brands');
        $countries = $request->get('countries');
        $managementModes = $request->get('management_modes');
        $profiles = $request->get('profiles');
        $now = time();

        foreach ($contents as $content) {
            $data = [
                'type' => 'node',
                'bundle' => $content['type'],
                'uuid' => $content['uuid'],
                'brands' => $brands,
                'countries' => $countries,
                'management_modes' => $managementModes,
                'profiles' => $profiles,
                'last_update' => $now,
            ];

            if (in_array($content['type'], ['sops', 'rops'])) {
                $data['users'] = $users;
            }

            Queue::push(new BulkUpdate($content['type'], $data));
        }

        return response()->json(['success' => true]);
    }
}
