<?php

namespace Inside\BCLH\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Transformers\ContentTransformer;

/**
 * Content created event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class EbookGeneratedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * The user uuid.
     *
     * @var string
     */
    public $uuid;

    /**
     * Create a new ebook generated event instance.
     *
     * @param string $uuid
     */
    public function __construct(string $uuid)
    {
        $this->uuid = $uuid;
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): Channel
    {
        return new Channel('inside_bclh_ebook');
    }
}
