<?php

namespace Inside\BCLH\Audit\Tests\Ebook;

use Illuminate\Support\Facades\File;
use Inside\Settings\Audit\Tests\BaseTest;

class SopsPdf extends BaseTest
{
    public static function check(): bool
    {
        $sopsCount = type_to_class('sops')::query()->count();
        $path = storage_path('app/protected/pdf/sops');

        $sopsPdfsCount = File::exists($path)
            ? count(File::files($path))
            : 0;

        self::setMessage($sopsPdfsCount.'/'.$sopsCount);

        return $sopsCount === $sopsPdfsCount;
    }

    public static function getLabel(): string
    {
        return 'SOPs (PDFs / Contents)';
    }
}
