<?php

namespace Inside\BCLH\Audit\Tests\Ebook;

use Illuminate\Support\Facades\File;
use Inside\Settings\Audit\Tests\BaseTest;

class RopsPdf extends BaseTest
{
    public static function check(): bool
    {
        $ropsCount = type_to_class('rops')::query()->count();
        $path = storage_path('app/protected/pdf/rops');

        $ropsPdfsCount = File::exists($path)
            ? count(File::files($path))
            : 0;

        self::setMessage($ropsPdfsCount.'/'.$ropsCount);

        return $ropsCount === $ropsPdfsCount;
    }

    public static function getLabel(): string
    {
        return 'Rops (PDFs / Contents)';
    }
}
