<?php

namespace Inside\BCLH\Audit\Tests\Ebook;

use Illuminate\Support\Facades\File;
use Inside\Settings\Audit\Tests\BaseTest;

class PagesPdf extends BaseTest
{
    public static function check(): bool
    {
        $pagesCount = type_to_class('pages')::query()->count();
        $path = storage_path('app/protected/pdf/pages');

        $pagesPdfsCount = File::exists($path)
            ? count(File::files($path))
            : 0;

        self::setMessage($pagesPdfsCount.'/'.$pagesCount);

        return $pagesCount === $pagesPdfsCount;
    }

    public static function getLabel(): string
    {
        return 'Pages (PDFs / Contents)';
    }
}
