<?php

namespace Inside\BCLH\Audit\Tests\Ebook;

use Illuminate\Support\Facades\File;
use Inside\Settings\Audit\Tests\BaseTest;

class FoldersPdf extends BaseTest
{
    public static function check(): bool
    {
        $foldersCount = type_to_class('folders')::query()->count();
        $path = storage_path('app/protected/pdf/folders');

        $foldersPdfsCount = File::exists($path)
            ? count(File::files($path))
            : 0;

        self::setMessage($foldersPdfsCount.'/'.$foldersCount);

        return $foldersCount === $foldersPdfsCount;
    }

    public static function getLabel(): string
    {
        return 'Folders (PDFs / Contents)';
    }
}
