<?php

namespace Inside\BCLH\Audit\Tests\Ebook;

use Illuminate\Support\Facades\File;
use Inside\Settings\Audit\Tests\BaseTest;

class DocumentsPdf extends BaseTest
{
    public static function check(): bool
    {
        $documentsCount = type_to_class('documents')::query()->count();
        $path = storage_path('app/protected/pdf/documents');

        $documentsPdfsCount = File::exists($path)
            ? count(File::files($path))
            : 0;

        self::setMessage($documentsPdfsCount.'/'.$documentsCount);

        return $documentsCount === $documentsPdfsCount;
    }

    public static function getLabel(): string
    {
        return 'Documents (PDFs / Contents)';
    }
}
