<?php

namespace Inside\BCLH\Audit\Tests\Ebook;

use Illuminate\Support\Facades\File;
use Inside\Settings\Audit\Tests\BaseTest;

class DeclinedDocumentsPdf extends BaseTest
{
    public static function check(): bool
    {
        $declinedDocumentsCount = type_to_class('declined_documents')::query()->count();
        $path = storage_path('app/protected/pdf/declined_documents');

        $declinedDocumentsPdfsCount = File::exists($path)
            ? count(File::files($path))
            : 0;

        self::setMessage($declinedDocumentsPdfsCount.'/'.$declinedDocumentsCount);

        return $declinedDocumentsCount === $declinedDocumentsPdfsCount;
    }

    public static function getLabel(): string
    {
        return 'Declined documents (PDFs / Contents)';
    }
}
