<style>
    @page {
        margin: 0;
    }


    /*COVER*/
    #cover {
        page-break-after: always;
    }

    #cover img {
        width: 7cm;
    }


    /*GENERAL*/
    body {
        font-family: sans-serif;
        margin: 1cm;
        margin-top: 3.5cm;
        margin-bottom: 3.5cm;
        text-align: justify;
    }

    #header,
    #footer {
        position: fixed;
        left: 0;
        right: 0;
        color: #2C3E50;
        font-size: 0.9em;
    }

    #header {
        top: 1cm;
        height: 4cm;
        text-align: center;
    }

    #header img {
        width: 4cm;
    }

    #footer {
        padding-top: .3cm;
        bottom: 1.5cm;
        margin-left: 2cm;
        margin-right: 2cm;
        border-top: 0.2pt solid #979797;
    }

    .spacer {
        height: 2cm;
    }

    .spacer.little {
        height: 1cm;
    }

    .spacer.mini {
        height: 0.5cm;
    }

    .spacer + .spacer {
        display: none;
    }

    .center,
    .title--centered {
        position: absolute;
        top: 50%;
        left: 50%;
        width: max-content;
        transform: translate(-50%, -50%);
        text-align: center;
    }

    .title--centered {
        display: block;
        max-width: 10cm;
    }

    .page-title {
        text-align: left;
        font-weight: bold;
    }

    .page-date {
        text-align: right;
        font-weight: bold;
    }

    hr {
        page-break-after: always;
        border: 0;
    }


    /*TEXTS*/
    h2,
    h3 {
        color: #2C3E50;
        text-align: center;
    }

    h2 {
        font-size: 1.4em;
        padding: 0;
        margin-top: 0.7cm;
        margin-bottom: 0;
    }

    h2.goals {
        margin-top: 0.3cm;
    }

    h2.title {
        font-size: 1.7em;
        margin-top: 0;
        margin-bottom: 0;
        padding: 0;
    }


    /*SUMMARY*/
    #summary h2 {
        margin: 2cm 0;
    }

    #summary ul {
        list-style-type: none;
    }

    #summary > ul {
        padding: 0;
    }

    #summary > ul > li {
        margin-bottom: 1cm;
        border-bottom: 0;
        color: #2C3E50;
        font-size: 1.7em;
        font-weight: bold;
    }

    #summary li {
        padding: .2cm 0;
    }

    #summary li > ul > li {
        border-bottom: 1px dashed #979797;
    }

    #summary li > ul {
        margin-top: .4cm;
        font-size: .7em;
        font-weight: normal;
    }


    /*CONTENT*/
    /*COMPANIES*/
    .wrapper {
        padding: .2cm .7cm .2cm .7cm;
        background-color: #F2F2F2;
        text-align: center;
    }

    .wrapper .company {
        display: inline-block;
        position: relative;
        margin-right: .2cm;
        margin-bottom: .2cm;
        width: 3cm;
        height: 1.5cm;
    }

    .wrapper .company img {
        position: absolute;
        z-index: 9999999999;
        top: .75cm;
        left: 1.5cm;
        transform: translate(-50%, -50%);
        max-width: 3cm;
        max-height: 1.5cm;
    }

    /*LIST WRAPPER*/
    p {
        font-size: 12px;
    }

    .wysiwyg {
        max-width: 100%;
        padding: 0;
        margin: 0;
        font-size: 12px!important;
    }

    .wysiwyg p {
        padding: 0;
        margin: 0 !important;
    }

    .wysiwyg p:first-child {
        margin-top: .3cm;
    }

    .wysiwyg h3 {
        text-align: left;
        color: #2C3E50;
        font-size: 1.2em;
    }

    .wysiwyg ul {
        padding-left: 0.5cm;
        margin: 0;
    }

    .wysiwyg ul li, .wysiwyg ol li {
        position: relative;
        padding-bottom: 0cm;
        line-height: 17px;
    }

    .wysiwyg ul.triangular-bullet li, .wysiwyg ol li {
        list-style-type: none;
    }

    .wysiwyg ol {
        counter-reset: bclh-counter;
    }

    .wysiwyg ol li {
        counter-increment: bclh-counter;
    }

    .wysiwyg ol li::before {
        content: counter(bclh-counter) ". ";
    }

    .wysiwyg ul.triangular-bullet li::before {
        content: "";
        border-color: transparent #A9A9AA;
        border-style: solid;
        border-width: 0.35em 0 0.35em 0.45em;
        display: block;
        height: 0;
        width: 0;
        left: -1em;
        top: 1.15em;
        position: relative;
    }

    .wysiwyg ul li.answer::before {
        border: none;
    }

    .wysiwyg table {
        max-width: 100%;
        width: auto;
    }

    .wysiwyg table td {
        width: auto;
    }

    .image-wrapper {
        text-align: center;
    }

    .image-wrapper img {
        margin: 0 !important;
    }

    .wysiwyg img {
        max-width: 100%;
    }

    .wysiwyg.mixed img {
        max-width: 40%;
        display: inline-block;
    }

    .wysiwyg.mixed .body {
        max-width: 50%;
        display: inline-block;
    }

    .introduction {
        padding-top: 5px;
        background-color: #F2F2F2;
        text-align: center;
    }

    .introduction h2 {
        margin-bottom: 0;
    }

    .wysiwyg.left {
        padding-right: 10px;
    }

    .wysiwyg.right {
        padding-left: 10px;
    }

    table.section, table.section tr, table.section td {
        vertical-align: top;
        text-align: justify;
    }

    .rop {
        page-break-inside: avoid;
    }

    .rop p {
        color: #929293;
        font-size: 0.7em;
    }

    /*STEPS WRAPPER*/
    .step {
        page-break-inside: avoid;
    }

    .step .image,
    .step .text {
        display: inline-block;
        position: relative;
        width: 50%;
        height: 6cm;
    }

    .step .image .content,
    .step .text .content {
        position: absolute;
        top: 3cm;
        left: 50%;
        width: 7cm;
        height: 4.4cm;
        transform: translate(-50%, -50%);
        text-align: center;
    }

    .step .image {
        position: relative;
        background-color: #F2F2F2;
    }

    .step .image::before {
        content: "";
        display: block;
        position: absolute;
        top: 3cm;
        right: -.9rem;
        transform: translateY(-50%);
        width: 0;
        height: 0;
        border-color: transparent #F2F2F2;
        border-style: solid;
        border-width: .8em 0 .8em .9em;
    }

    .step .image.right::before {
        right: auto;
        left: -.9rem;
        border-width: .8em .9em .8em 0;
    }

    .step .image .content img {
        max-width: 100%;
        max-height: 100%;
    }

    .step {
        page-break-inside: avoid;
    }

    @page

    .step:first-of-type {
        margin-top: 5cm;
    }


    /*INFOS*/
    .infos table {
        margin-top: .5cm;
        padding: 1cm;
        padding-top: .5cm;
        padding-bottom: .5cm;
        background-color: #F2F2F2;
        border-radius: 1cm;
        page-break-inside: avoid;
    }

    .infos td {
        vertical-align: top;
        padding-left: .7cm;
        border-left: 1px solid #B5B5B5;
    }

    .infos td:first-of-type {
        border: none;
    }

    .infos td p {
        margin: .1cm 0;
    }

    .infos td .title {
        color: #2C3E50;
        font-weight: bold;
    }

    .infos td .mail {
        color: #A9A9AA;
    }
</style>
