<!doctype html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <title>{{ $sop['title'] }}</title>
    @include('styles')
</head>
<body>
@include('header')
@include('footer', ['title' => $sop['folder'], 'date' => $sop['date'], 'langcode' => $sop['langcode']])
<div class="wrapper">
    <h2 class="title">{{ $sop['title'] }}</h2>
</div>

<h2 class="goals">{{ \Illuminate\Support\Facades\Lang::getFromJson('bclh.pdf.goals', [], $sop['langcode']) }}</h2>
<div class="wysiwyg">
    {!! $sop['goal'] !!}
</div>

<h2>{{ \Illuminate\Support\Facades\Lang::getFromJson('bclh.pdf.standards', [], $sop['langcode']) }}</h2>
<div class="wysiwyg">
    {!! $sop['standard'] !!}
</div>

<h2>{{ \Illuminate\Support\Facades\Lang::getFromJson('bclh.pdf.process', [], $sop['langcode']) }}</h2>
@include('sections', ['contents' => $sop['contents']])

@if (!empty($sop['contact']) || !empty($sop['country']) || !empty($sop['managementMode']))
    <div class="infos">
        <table width="100%">
            <tr>
                @if (!empty($sop['contact']))
                    <td width="33%">
                        <p class="title">Contact</p>
                        <p>{{ $sop['contact']['firstname'] }} {{ $sop['contact']['lastname'] }}</p>
                        <p class="mail">{{ $sop['contact']['email'] }}</p>
                    </td>
                @endif
                @if (!empty($sop['country']))
                    <td width="33%">
                        <p class="title">Pays</p>
                        <p>{{ $sop['country'] }}</p>
                    </td>
                @endif
                @if (!empty($sop['managementMode']))
                    <td width="33%">
                        <p class="title">Mode de gestion</p>
                        <p>{{ $sop['managementMode'] }}</p>
                    </td>
                @endif
            </tr>
        </table>
    </div>
@endif

@if ($sop['is_rop'])
    <div class="rop">
        <p>
            This ROP does not supersede and is subject to any legal or contractual requirements that may be in force in your location. Nothing in the ROP, or any amendment, revision or modification thereof, shall be deemed to release hotels from any obligations imposed by applicable laws or regulations or contractual requirements. ROPs are prepared and issued by your Regional Office and are not reviewed or approved by Louvre Hotels Group. Louvre Hotels Group makes no representation or warranties as to the accuracy or completeness of the information set out in the ROPs and, to the extent not prohibited by law, accepts no liability in respect thereof.
        </p>
    </div>
@endif
</body>
</html>
