<?php

use Inside\Content\Models\Contents\Movements;

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => 'nl_',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/bclh-back/resources/assets/newsletter/logo.png',
        'logoWidth' => 320,
        'showDate' => false,
    ],
    'banner' => [
        'backgroundImageUrl' => [
            'fr' => 'vendor/maecia/bclh-back/resources/assets/newsletter/banner.png',
            'en' => 'vendor/maecia/bclh-back/resources/assets/newsletter/banner-en.png',
        ],
        'backgroundColor' => '#FFFFF',
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
    ],
    'sections' => [
        'sops' => [
            'types' => ['sops'],
            'defaultImageUrl' => 'vendor/maecia/bclh-back/resources/assets/newsletter/default-sop.png',
            'showIntroduction' => true,
            'introductionFieldName' => 'goal',
            'link' => null,
        ],
        'rops' => [
            'types' => ['rops'],
            'defaultImageUrl' => 'vendor/maecia/bclh-back/resources/assets/newsletter/default-rop.png',
            'showIntroduction' => true,
            'introductionFieldName' => 'goal',
            'link' => null,
        ],
        'updated_sops' => [
            'types' => ['updated_sops' => 'sops'],
            'defaultImageUrl' => 'vendor/maecia/bclh-back/resources/assets/newsletter/default-sop.png',
            'showIntroduction' => true,
            'introductionFieldName' => 'goal',
            'link' => null,
        ],
        'updated_rops' => [
            'types' => ['updated_rops' => 'rops'],
            'defaultImageUrl' => 'vendor/maecia/bclh-back/resources/assets/newsletter/default-rop.png',
            'showIntroduction' => true,
            'introductionFieldName' => 'goal',
            'link' => null,
        ],
    ],
    'cta' => [
        'logoUrl' => 'vendor/maecia/bclh-back/resources/assets/newsletter/logo-cta.png',
        'backgroundColor' => '#263D51',
        'sectionLinkStrKey' => 'Accéder au Brand Center',
        'sectionTextColor' => '#FFFFFF',
        'sectionLinkUrl' => env('APP_URL'),
    ],
    'footer' => [
    ],
];
