<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Eloquent\Builder;
use Inside\Host\Bridge\BridgeContent;

class AddCustomPageDashboardProcedures extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        /** @var Builder $query */
        $query = type_to_class('custom')::query()
            ->where('langcode', 'fr')
            ->where('redirection_page', 'DashboardListingProcedures');

        if ($query->doesntExist()) {
            $uuid = $bridge->contentInsert('custom', [
                'type' => 'node',
                'bundle' => 'custom',
                'title' => 'Procédure corporate',
                'redirection_page' => 'DashboardListingProcedures',
                'langcode' => 'fr',
                'status' => true,
            ], true, true);

            $uuidHost = $query = type_to_class('custom')::query()
                ->where('uuid', $uuid)
                ->first()
                ->uuid_host;
        } else {
            $uuidHost = $query->first()->uuid_host;
        }

        $query = type_to_class('custom')::query()
            ->where('uuid_host', $uuidHost)
            ->where('langcode', 'en')
            ->where('redirection_page', 'DashboardListingProcedures');

        if ($query->doesntExist()) {
            $bridge->contentInsert('custom', [
                'uuid_host' => $uuidHost,
                'type' => 'node',
                'bundle' => 'custom',
                'title' => 'Corporate procedure',
                'redirection_page' => 'DashboardListingProcedures',
                'langcode' => 'en',
                'status' => true,
            ], true, true);
        }
    }
}
