<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class BulkExportErrorsNotificationTypes extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\BCLH\Events\BulkCSVExportFailedEvent',
                'model' => null,
                'type' => 'system',
                'action' => 'bulkCSV-export-failed',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.bulkCSV.export.failed.title',
                    'description' => 'notifications.bulkCSV.export.failed.description',
                    'icon' => '',
                    'text' => 'notifications.bulkCSV.export.failed.text',
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
