<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Eloquent\Builder;
use Inside\Host\Bridge\BridgeContent;

class AddCustomPageDashboardValidate extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        /** @var Builder $query */
        $query = type_to_class('custom')::query()->where('redirection_page', 'DashboardListingToValidate');

        if ($query->where('langcode', 'fr')->doesntExist()) {
            $bridge->contentInsert('custom', [
                'type' => 'node',
                'bundle' => 'custom',
                'title' => 'Contenus en cours de validation',
                'redirection_page' => 'DashboardListingToValidate',
                'langcode' => 'fr',
                'status' => true,
            ], true, true);
        }

        if ($query->where('langcode', 'en')->doesntExist()) {
            $bridge->contentInsert('custom', [
                'type' => 'node',
                'bundle' => 'custom',
                'title' => 'Contents being validated',
                'redirection_page' => 'DashboardListingToValidate',
                'langcode' => 'en',
                'status' => true,
            ], true, true);
        }
    }
}
