<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class FixInviteSection extends Migration
{
    public function up(): void
    {
        Artisan::call('inside:paragraph:config:generate');
        Artisan::call('inside:paragraph:config:import');

        $bridge = new BridgeContentType();

        collect(['sops', 'rops'])->each(fn ($type) => $bridge->contentTypeCreateOrUpdateField(
            type: $type,
            fieldName: 'content',
            options: [
                'name' => 'content',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 4,
                'title' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ],
                'description' => [
                    'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                    'en' => 'Select the different types of paragraphs you want to move up the page',
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => [
                        'text',
                        'text_with_image',
                        'image',
                        'video',
                        'html',
                        'accordion',
                        'call_to_action',
                        'files',
                        'slider',
                        'slide',
                        'invite',
                        'separator',
                    ],
                    'cardinality' => -1,
                ],
            ])
        );
    }
}
