<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class FixImagesInGlobalSearch extends Migration
{
    private const TYPES = [
        'brands' => 'menu_icon',
        'folders' => 'image',
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach (self::TYPES as $type => $field) {
            $bridge->updateFieldOptions($type, $field, [
                'searchable' => true,
                'global_searchable' => true,
            ]);
        }

        Artisan::call('index:rebuild', ['--type' => 'sops']);
        Artisan::call('index:rebuild', ['--type' => 'rops']);
    }
}
