<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ModifyRopsAndSopsLabelsInNewslettersContentType extends Migration
{
    const FIELDS = [
        [
            'field' => 'nl_sops',
            'title_fr' => 'Nouvelles SOPs',
            'title_en' => 'New SOPs',
        ],
        [
            'field' => 'nl_updated_sops',
            'title_fr' => 'SOPs modifiées',
            'title_en' => 'Updated SOPs',
        ],
        [
            'field' => 'nl_rops',
            'title_fr' => 'Nouvelles ROPs',
            'title_en' => 'New ROPs',
        ],
        [
            'field' => 'nl_updated_rops',
            'title_fr' => 'ROPs modifiées',
            'title_en' => 'Updated ROPs',
        ],
    ];

    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        collect(self::FIELDS)->each(fn ($data) => $bridgeContentType->changeFieldTitle('newsletters', $data['field'], [
            'fr' => $data['title_fr'],
            'en' => $data['title_en'],
        ]));
    }
}
