<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixUsersAndRelationships extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'brands', [
            'name' => 'brands',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 14,
            'title' => [
                'en' => 'Brands',
                'fr' => 'Marques',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 14,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'brands',
                'cardinality' => -1,
            ],
        ]);

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'countries', [
            'name' => 'countries',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 15,
            'title' => [
                'en' => 'Countries',
                'fr' => 'Pays',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 15,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'countries',
                'cardinality' => -1,
            ],
        ]);

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'business_units', [
            'name' => 'business_units',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 17,
            'title' => [
                'en' => 'Business Units',
                'fr' => 'Business Units',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 17,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'business_units',
                'cardinality' => -1,
            ],
        ]);

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'profiles', [
            'name' => 'profiles',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 18,
            'title' => [
                'en' => 'Profiles',
                'fr' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 18,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'profiles',
                'cardinality' => -1,
            ],
        ]);

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'regional_offices', [
            'name' => 'regional_offices',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 19,
            'title' => [
                'en' => 'Regional Offices',
                'fr' => 'Bureaux régionaux',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 19,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'regional_offices',
                'cardinality' => -1,
            ],
        ]);

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'management_modes', [
            'name' => 'management_modes',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 20,
            'title' => [
                'en' => 'Management Modes',
                'fr' => 'Modes de gestion',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 20,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'management_modes',
                'cardinality' => -1,
            ],
        ]);
    }
}
