<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class MakeContentTypesAliasable extends Migration
{
    /**
     * @throws Exception
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $contentTypes = InsideSchema::getContentTypes();

        $blacklist = [
            // menus
            'admin_menus',
            'footer_menus',
            'shortcuts_menus',
            'main_menus',
            'tools_menus',

            // categories
            'management_modes',
            'contacts',
            'countries',
            'modal',
            'photo',
            'procedures_categories',

            // system
            'image_styles',
            'comments',
            'users',
        ];

        collect($contentTypes)->diff($blacklist)->each(
            static fn ($contentType) => $bridge->contentTypeUpdate($contentType, ['aliasable' => true])
        );
    }
}
