<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\ProceduresCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ReplaceBannerFieldOnProcedures extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $fields = [
            [
                'name' => 'image',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'en' => 'Banner',
                    'fr' => 'Bannière',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
                'special' => [
                    'image_styles' => [
                        'image_grouping',
                    ],
                ],
            ],
        ];

        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        foreach ($fields as $field) {
            $bridge->contentTypeCreateOrUpdateField('procedures_categories', $field['name'], $field, $field['weight']);
        }

        $categories = ProceduresCategories::query()->get();

        foreach ($categories as $category) {
            $bridgeContent->contentUpdate('procedures_categories', [
                'type' => 'node',
                'bundle' => 'procedures_categories',
                'uuid' => $category->uuid,
                'image' => $category->banner,
            ]);
        }

        $bridge->contentTypeDeleteField('node', 'procedures_categories', 'banner');

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
