<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddProcedures extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('procedures_categories', false);
        $this->migrateContent('procedures', false);

        $fields = [
            [
                'name' => 'users',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'en' => 'Corporate contacts',
                    'fr' => 'Contacts corporate',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => -1,
                ],
            ],
        ];

        $bridge = new BridgeContentType();

        foreach ($fields as $field) {
            $bridge->contentTypeCreateOrUpdateField('brands', $field['name'], $field);
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
