<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Rops;
use Inside\Host\Bridge\BridgeContent;

class AddFoldersOnExistingRops extends Migration
{
    public function up(): void
    {
        $rops = Rops::query()->get();

        $bridge = new BridgeContent();

        $output = new Symfony\Component\Console\Output\ConsoleOutput();
        $bar = new Symfony\Component\Console\Helper\ProgressBar($output, $rops->count());
        $bar->setFormat("%message%\n %current%/%max% [%bar%] %percent:3s%%");
        $bar->setMessage('Fixing folder references for '.$rops->count().' rops');
        $bar->start();

        $time = time();

        foreach ($rops as $rop) {
            $bar->setMessage('Fixing folder reference for rop '.$rop->title);
            $bar->advance();

            if ($rop->sops->count() === 0) {
                continue;
            }

            $folder = $rop->sops->first()->folders->first();

            if (empty($folder)) {
                continue;
            }

            $sourceSections = $rop->sectionContent ?? [];

            $content = [];
            foreach ($sourceSections as $sourceSection) {
                $section = [
                    'bundle' => str_replace('inside_section_', '', $sourceSection->getTable()),
                ];

                $section = array_merge($section, $sourceSection->toArray());

                if ($section['bundle'] === 'tabs') {
                    $pages = $sourceSection->pages;

                    $section['pages'] = [];
                    foreach ($pages as $page) {
                        $langcode = ($page->langcode === $rop->langcode && $page->langcode === 'en') ? 'fr' : 'en';
                        $page = $page->getTranslationIfExist($langcode);

                        if ($page->langcode !== $rop->langcode) {
                            $section['pages'][] = $page->uuid;
                        }
                    }
                }

                $sourceSection = call_user_func(get_class($sourceSection).'::find', $sourceSection->uuid);

                if (isset($sourceSection->sectionContent)) {
                    $section['content'] = [];

                    $subSections = $sourceSection->sectionContent;

                    foreach ($subSections as $subSectionContent) {
                        $subSection = [
                            'bundle' => str_replace('inside_section_', '', $subSectionContent->getTable()),
                        ];

                        $subSection = array_merge($subSection, $subSectionContent->toArray());

                        $section['content'][] = $subSection;

                        $subSectionContent = null;
                    }

                    $subSections = null;
                }

                $sourceSection = null;

                $content[] = $section;
            }

            $bridge->contentUpdate('rops', [
                'uuid_host' => $rop->uuid_host,
                'langcode' => $rop->langcode,
                'folders' => [$folder->uuid],
                'last_update' => $time,
                'updated_by' => ['1d4f5c59-46c8-44c1-b939-d63a2e206cf8'],
                'content' => $content,
            ]);
        }
    }

    public function down(): void
    {
    }
}
