<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class BulkCSVNotificationTypes extends Migration
{
    public function up(): void
    {
        $notificationTypes = [];

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\BCLH\Events\BulkCSVGeneratedEvent',
                'model' => null,
                'type' => 'global',
                'action' => 'bulkCSV-export',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.bulkCSV.export.title',
                    'description' => 'notifications.bulkCSV.export.description',
                    'icon' => 'ebook',
                    'text' => 'notifications.bulkCSV.export.text',
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\BCLH\Events\BulkCSVImportedEvent',
                'model' => null,
                'type' => 'global',
                'action' => 'bulkCSV-import',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.bulkCSV.import.title',
                    'description' => 'notifications.bulkCSV.import.description',
                    'icon' => '',
                    'text' => 'notifications.bulkCSV.import.text',
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\BCLH\Events\BulkCSVImportedEvent',
                'model' => null,
                'type' => 'global',
                'action' => 'bulkCSV-import-failed',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.bulkCSV.import.failed.title',
                    'description' => 'notifications.bulkCSV.import.failed.description',
                    'icon' => '',
                    'text' => 'notifications.bulkCSV.import.failed.text',
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
