<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\BrandForms;
use Inside\Host\Bridge\BridgeContent;

class BrandFormsContents extends Migration
{
    public function up(): void
    {
        $contents = [
            [
                'title' => [
                    'en' => 'Campanile card',
                    'fr' => 'Campanile card',
                ],
                'form_id' => 'campanile_card',
                'introduction' => [
                    'en' => 'Campanile',
                    'fr' => 'Campanile',
                ],
            ],
            [
                'title' => [
                    'en' => 'Campanile signature',
                    'fr' => 'Campanile signature',
                ],
                'form_id' => 'campanile_signature',
                'introduction' => [
                    'en' => 'Lorem',
                    'fr' => 'Lorem',
                ],
            ],
            [
                'title' => [
                    'en' => 'Golden tulip card',
                    'fr' => 'Golden tulip card',
                ],
                'form_id' => 'golden-tulip_card',
                'introduction' => [
                    'en' => 'Golden tulip',
                    'fr' => 'Golden tulip',
                ],
            ],
            [
                'title' => [
                    'en' => 'Golden tulip signature',
                    'fr' => 'Golden tulip signature',
                ],
                'form_id' => 'golden-tulip_signature',
                'introduction' => [
                    'en' => 'Golden Tulip',
                    'fr' => 'Golden Tulip',
                ],
            ],
            [
                'title' => [
                    'en' => 'Kyriad card',
                    'fr' => 'Kyriad card',
                ],
                'form_id' => 'kyriad_card',
                'introduction' => [
                    'en' => 'Kyriad card',
                    'fr' => 'Kyriad card',
                ],
            ],
            [
                'title' => [
                    'en' => 'Kyriad Direct card',
                    'fr' => 'Kyriad Direct card',
                ],
                'form_id' => 'kyriad-direct_card',
                'introduction' => [
                    'en' => 'KD card',
                    'fr' => 'KD card',
                ],
            ],
            [
                'title' => [
                    'en' => 'Kyiad signature',
                    'fr' => 'Kyiad signature',
                ],
                'form_id' => 'kyriad_signature',
                'introduction' => [
                    'en' => 'Kyriad signature',
                    'fr' => 'Kyriad signature',
                ],
            ],
            [
                'title' => [
                    'en' => 'Première classe card',
                    'fr' => 'Première classe card',
                ],
                'form_id' => 'premiere-classe_card',
                'introduction' => [
                    'en' => '',
                    'fr' => '',
                ],
            ],
            [
                'title' => [
                    'en' => 'Première classe signature',
                    'fr' => 'Première classe signature',
                ],
                'form_id' => 'premiere-classe_signature',
                'introduction' => [
                    'en' => 'Première classe',
                    'fr' => 'Première classe',
                ],
            ],
        ];

        $bridge = new BridgeContent();

        foreach ($contents as $content) {
            $brandForm = BrandForms::query()->where('form_id', $content['form_id'])->first();

            if ($brandForm) {
                continue;
            }

            $english = $bridge->contentUpdate('brand_forms', [
                'type' => 'node',
                'bundle' => 'brand_forms',
                'title' => $content['title']['en'],
                'form_id' => $content['form_id'],
                'introduction' => $content['introduction']['en'],
                'langcode' => 'en',
            ]);

            $brandForm = BrandForms::query()->find($english);

            $bridge->contentUpdate('brand_forms', [
                'uuid_host' => $brandForm->uuid_host,
                'type' => 'node',
                'bundle' => 'brand_forms',
                'title' => $content['title']['fr'],
                'form_id' => $content['form_id'],
                'introduction' => $content['introduction']['fr'],
                'langcode' => 'fr',
            ]);
        }
    }

    public function down(): void
    {
    }
}
