<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersAttributesCombinaisonContentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_users_attributes_combinaison_contents', function (Blueprint $table) {
            $table->string('content_type');
            $table->char('content_uuid', 36)->collate('utf8');
            $table->unsignedBigInteger('users_attributes_combinaisons_id');

            $table->index(['content_type', 'content_uuid'], 'index_content');
            $table->unique(['content_type', 'content_uuid', 'users_attributes_combinaisons_id'], 'unique_content_combinaison');
        });
        Schema::table('inside_users_attributes_combinaison_contents', function (Blueprint $table) {
            $table->foreign('users_attributes_combinaisons_id', 'iuaco_users_attributes_combinaisons_id_foreign')
                ->references('id')->on('inside_users_attributes_combinaisons')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('inside_users_attributes_combinaison_contents', function (Blueprint $table) {
            $table->dropForeign('iuaco_users_attributes_combinaisons_id_foreign');
        });
        Schema::dropIfExists('inside_users_attributes_combinaison_contents');
    }
}
