<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersAttributesCombinaisonUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_users_attributes_combinaison_users', function (Blueprint $table) {
            $table->char('user_uuid', 36)->collate('utf8');
            $table->unsignedBigInteger('users_attributes_combinaisons_id');

            $table->index('user_uuid');
            $table->unique(['user_uuid', 'users_attributes_combinaisons_id'], 'unique_user_combinaison');
        });
        Schema::table('inside_users_attributes_combinaison_users', function (Blueprint $table) {
            $table->foreign('user_uuid', 'iucu_user_uuid_foreign')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');
            $table->foreign('users_attributes_combinaisons_id', 'iucu_users_combinaisons_id_foreign')
                ->references('id')->on('inside_users_attributes_combinaisons')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('inside_users_attributes_combinaison_users', function (Blueprint $table) {
            $table->dropForeign('iuau_user_uuid_foreign');
            $table->dropForeign('iuau_users_attributes_combinaisons_id_foreign');
        });
        Schema::dropIfExists('inside_users_attributes_combinaison_users');
    }
}
