<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => false,
        'categorizable'     => false,
        'name'              => 'brand_forms',
        'title'             => [
            'en' => 'Brand forms',
            'fr' => 'Formulaires de marques',
        ],
    ],
    'fields' => [
        [
            'name' => 'form_id',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'en' => 'Form ID',
                'fr' => 'ID du formulaire',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 27,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'en' => 'Introduction',
                'fr' => 'Introduction',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::LONGTEXT_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
