<?php

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\Carbon;

return [
    'schedule' => [
        'create_auto_newsletters' => fn (Schedule $scheduler) => $scheduler
            ->command('inside:newsletter:scheduled:create newsletters')
            ->monthlyOn((int) Carbon::parse('first monday of this month')->format('d'), '2:00'),
        'send_test_auto_newsletters' => fn (Schedule $scheduler) => $scheduler
            ->command('inside:newsletter:scheduled:send --type=newsletters --test')
            ->monthlyOn((int) Carbon::parse('first monday of this month')->format('d'), '10:00'),
    ],
];
