<?php

use Illuminate\Support\Carbon;
use Inside\Database\Eloquent\Builder;

$firstDayOfLastMonth = Carbon::now()->startOfMonth()->subMonthsNoOverflow()->toDateTimeString();

return [
    'types' => [
        'newsletters' => [
            'global_config_disabled' => true,
            'notification' => [
                'view' => 'newsletter',
                'title' => 'notifications.create.newsletters.monthly.sent.mail.title',
                'description' => 'notifications.create.newsletters.monthly.sent.mail.description',
                'mail' => [
                    'subject' => 'notifications.create.newsletters.monthly.sent.mail.subject',
                ],
            ],
            'default_roles' => ['Business Unit', 'Régions', 'Directeur hôtel', 'Equipe hôtel', 'Investisseurs', 'Prestataire', 'super_administrator'],
            'scheduled' => env('ENABLE_SCHEDULED_NEWSLETTER', false),
            'scheduled_options' => [
                'roles' => ['Business Unit', 'Régions', 'Directeur hôtel', 'Equipe hôtel', 'Investisseurs', 'Prestataire', 'super_administrator'],
                'test_roles' => ['super_administrator'],
                'date_limit' => false,
                'introductionFieldName' => 'newsletter_introduction',
                'fields' => [
                    'nl_sops' => [
                        'content_type' => 'sops',
                        'custom_query' => fn (Builder $query) => $query
                            ->where('published_at', '>=', $firstDayOfLastMonth)
                            ->latest('published_at'),
                    ],
                    'nl_updated_sops' => [
                        'content_type' => 'sops',
                        'custom_query' => fn (Builder $query) => $query
                            ->where('published_at', '<', $firstDayOfLastMonth)
                            ->where('updated_at', '>=', $firstDayOfLastMonth)
                            ->latest('updated_at'),
                    ],
                    'nl_rops' => [
                        'content_type' => 'rops',
                        'custom_query' => fn (Builder $query) => $query
                            ->where('published_at', '>=', $firstDayOfLastMonth)
                            ->latest('published_at'),
                    ],
                    'nl_updated_rops' => [
                        'content_type' => 'rops',
                        'custom_query' => fn (Builder $query) => $query
                            ->where('published_at', '<', $firstDayOfLastMonth)
                            ->where('updated_at', '>=', $firstDayOfLastMonth)
                            ->latest('updated_at'),
                    ],
                ],
            ],
        ],
    ],
];
