import { http } from '@inside-library/helpers/Http'
import { upcomingEventsDateFilters } from '@inside-events/constants'

const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'background_color',
              'dark_mode',
              'icon',
              'image',
              'link',
              'admin',
              'content_type',
              'link_label',
              'open_in_new_tab'
            ],
            filters: { 'status:eq': 1, 'archived:eq': 0 }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'file',
              'has_section',
              'admin',
              'content_type',
              'published_at'
            ],
            filters: { 'status:eq': 1, 'archived:eq': 0 }
          }
        },
        {
          folders: ['uuid', 'title']
        },
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1,
              'archived:eq': 0
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              'icon',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1,
              'archived:eq': 0
            }
          }
        },
        {
          events_categories: {
            fields: [
              'uuid',
              'title',
              {
                events: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'date',
                    'place',
                    'content_type',
                    { events_categories: ['uuid', 'title'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    'archived:eq': 0,
                    'published_at:lte': 'now()',
                    limit: 3,
                    ...upcomingEventsDateFilters
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'archived:eq': 0,
              'published_at:lte': 'now()'
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'introduction',
                    'published_at',
                    'image',
                    'chapo',
                    'content_type',
                    { news_categories: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    'archived:eq': 0,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'archived:eq': 0,
              'published_at:lte': 'now()'
            }
          }
        },
        {
          pages_categories: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchTabSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSpace, fetchTabSpace }
