export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'image',
      'firstname',
      'lastname',
      'function',
      'linkedin',
      'team',
      'email',
      'mobile_phone',
      'hobby',
      'skill',
      'birthday',
      'mission',
      'referent',
      {
        manager: ['firstname', 'lastname', 'uuid', 'function', 'image', 'phone']
      },
      { services: ['uuid', 'title'] },
      { parks: ['uuid', 'title'] },
      { regions: ['uuid', 'title'] },
      {
        'users.manager': {
          fields: [
            'firstname',
            'lastname',
            'uuid',
            'function',
            'image',
            'phone'
          ],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0,
            alias: 'coworkers'
          }
        }
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
